#!/usr/bin/env python

keys_dict = {
    'spawn, SHCMD("pavucontrol; kill -44 $(pidof dwmblocks)")' : "Sound options gui",
    'spawn, SHCMD("pOS-displayselect")' : "Set display rate & resolution",
    'spawn, SHCMD("pOS-mount")' : "Mount device",
    'spawn, SHCMD("pOS-umount")' : "Unmount device",
    'spawn, SHCMD("mpv --no-cache --no-osc --no-input-default-bindings --profile=low-latency --input-conf=/dev/null --title=webcam $(ls /dev/video[0,2,4,6,8] | tail -n 1)")' : "Open camera",
    'view, {.ui = ~0}' : "Show all tags",
    'spawn, SHCMD("pOS-unicode")' : "Choose emoji & copy",
    'setlayout, {.v = &layouts[0]}' : "Tiled layout",
    'setlayout, {.v = &layouts[1]}' : "Backstack layout",
    'setlayout, {.v = &layouts[2]}' : "Monocle layout",
    'setlayout, {.v = &layouts[3]}' : "Deck layout",
    'setlayout, {.v = &layouts[4]}' : "Spiral layout",
    'setlayout, {.v = &layouts[5]}' : "Dwindle layout",
    'setlayout, {.v = &layouts[6]}' : "Centered master layout",
    'setlayout, {.v = &layouts[7]}' : "Centered floatin master layout",
    'setlayout, {.v = &layouts[8]}' : "Floating (like Windows)",
    'spawn, SHCMD("pOS-powermenu")' : "Open power menu",
    'spawn, SHCMD("pOS-windowswitchcurtag")' : "Switch between clients in curtag",
    'spawn, SHCMD("pOS-windowswitch")' : "Switch between clients in all tags",
    'killclient, {0}': "Quit window",
    'spawn, SHCMD("$BROWSER")' : "Open browser ($BROWSER)",
    'spawn, SHCMD("pidof -s $COMPOSITOR && killall -9 $COMPOSITOR || pOS-compositor &")' : "Toggle picom",
    'spawn, SHCMD(MAKETERM(TERMINAL, " -e lf"))' : "Open lf (file manager)",
    'spawn, SHCMD("pass_menu")' : "Open password manager",
    'spawn, SHCMD(MAKETERM(TERMINAL, " -e htop"))' : "Open htop",
    'spawn, SHCMD(MAKETERM(TERMINAL, " -e s-tui"))' : "Open stress test (check pc health)",
    'spawn, SHCMD("rofi -show drun")' : "Open applications menu",
    'spawn, {.v = dmenucmd}' : "Run dmenu",
    'togglesticky, {0}' : "Toggle sticky window",
    'spawn, SHCMD("pOS-maimpick ~/Pictures/")' : "Take screenshot",
    'spawn, SHCMD("pOS-choose-dir")' : "Open terminal in selected bookmark",
    'togglefullscr, {0}' : "Toggle fullscreen",
    'setmfact, {.f = -0.05}' : "Decrease master window size",
    'tagmon, {.i = -1}' : "Move focused window to prev monitor",
    'shiftview, {.i = -1}' : "Go to prev tag",
    'togglegaps, {0}' : "Toggle gaps",
    'defaultgaps, {0}' : "Set to default gaps",
    'focusmon, {.i = -1}' : "Focus prev monitor",
    'focusmon, {.i = +1}' : "Focus next monitor",
    'tagmon, {.i = +1}' : "Move focused window to next monitor",
    'setmfact, {.f = +0.05}' : "Increase master window size",
    'shiftview, {.i = +1}' : "Go to next tag",
    'spawn, {.v = termcmd}' : "Open $TERMINAL",
    'togglescratch, {.ui = 0}' : "Open scratchpad (floating term on center)",
    'incrgaps, {.i = +3}' : "Increase window gaps",
    'incrgaps, {.i = -3}' : "Decrease window gaps",
    'togglebar, {0}' : "Toggle bar",
    'incnmaster, {.i = +1}' : "Increase master window count",
    'incnmaster, {.i = -1}' : "Decrease master window count",
    'zoom, {0}' : "Set focused window as master window",
    'togglefloating, {0}' : "Toggle focused window to floating mode",
    'cyclelayout, {.i = -1}' : "Cycle to prev layout",
    'cyclelayout, {.i = +1}' : "Cycle to next layout",
    'spawn, SHCMD("mpc prev")' : "Switch to prev track",
    'spawn, SHCMD("mpc next")' : "Switch to next track",
    'spawn, SHCMD("mpc pause")' : "Pause track",
    'spawn, SHCMD("mpc play")' : "Play track",
    'spawn, SHCMD("mpc stop")' : "Stop track",
    'spawn, SHCMD("mpc seek -10")' : "Rewind track 10 seconds",
    'spawn, SHCMD("mpc seek +10")' : "Fast-forward track 10 seconds",
    'spawn, SHCMD("pOS-record")' : "Start recording",
    'spawn, SHCMD("pOS-record kill")' : "Stop recording",
    'spawn, SHCMD("pamixer -t; kill -44 $(pidof dwmblocks)")' : "Mute",
    'spawn, SHCMD("pamixer -i 3; kill -44 $(pidof dwmblocks)")' : "Increase volume",
    'spawn, SHCMD("pamixer -d 3; kill -44 $(pidof dwmblocks)")' : "Decrease volume",
    'spawn, SHCMD("pactl set-source-mute @DEFAULT_SOURCE@ toggle")' : "Mute microphone",
    'spawn, SHCMD("pOS-touchpadtoggle")' : "Toggle touchpad",
    'spawn, SHCMD("light -A 2 && pOS-brightness")' : "Increase brightness",
    'spawn, SHCMD("light -U 2 && pOS-brightness")' : "Decrease brightness",
    'spawn, SHCMD("var=$( ls /sys/class/leds/ | grep kbd_backlight ); light -s sysfs/leds/$var -r -U 1")' : "Increase keyboard backlight",
    'spawn, SHCMD("var=$( ls /sys/class/leds/ | grep kbd_backlight ); light -s sysfs/leds/$var -r -A 1")' : "Decrease keyboard backlight"
}

buttons_dict = {
    "sigdwmblocks, {.i = 1}" : "Left click on statusbar",
    "sigdwmblocks, {.i = 2}" : "Middle click on statusbar",
    "sigdwmblocks, {.i = 3}" : "Right click on statusbar",
    "sigdwmblocks, {.i = 4}" : "Wheel up on statusbar",
    "sigdwmblocks, {.i = 5}" : "Wheel down on statusbar",
    "movemouse, {0}" : "Drag window with mouse",
    "resizemouse, {0}" : "Resize window with mouse",
    "hide, {.i = -1}" : "Click to hide window",
    'spawn, SHCMD("jgmenu_run")' : "Spawn dropdown system menu",
    "layoutmenu, {0}" : "Layout dropdown menu",
    "shiftview, {.i = +1}" : "Go to next tag",
    "shiftview, {.i = -1}" : "Go to prev tag",
    "view, {0}" : "Click to select tag",
    "toggleview, {0}" : "Click to select multiple tag",
    "tag, {0}" : "Send focused to tag",
    "toggletag, {0}" : "Toggle focused on clicked tag",
}
